% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022
function [res, PARMS]   = agg_shocks_K(PARMS,steady)

% Data
define_data_moms_agg

%% Compute steady state F-matrix

xss             = steady.xss;
yss             = steady.yss;
nx              = length(xss);
ny              = length(yss);
fss             = Fsys(xss,xss,yss,yss,PARMS,steady);

%% Derivatives using first differences
fdfx            = zeros(nx+ny,nx);
fdfxp           = zeros(nx+ny,nx);
h               = 1e-6;
for i = 1:nx
    xvec        = xss;
    xvec(i)     = xvec(i)+h;
    fvec        = Fsys(xss,xvec,yss,yss,PARMS,steady);
    fdfx(:,i)   = (fvec-fss)./h;
    fvec        = Fsys(xvec,xss,yss,yss,PARMS,steady);
    fdfxp(:,i)  = (fvec-fss)./h;
end
fdfy            = zeros(nx+ny,ny);
fdfyp           = zeros(nx+ny,ny);
for i = 1:ny
    yvec        = yss;
    yvec(i)     = yvec(i)+h;
    fvec        = Fsys(xss,xss,yss,yvec,PARMS,steady);
    fdfy(:,i)   = (fvec-fss)./h;
    fvec        = Fsys(xss,xss,yvec,yss,PARMS,steady);
    fdfyp(:,i)  = (fvec-fss)./h;
end

%% First-order approximation (Schmitt-Grohe Uribe, 2004 JEDC)
stake           = 1 + sqrt(eps);
[gx,hx]         = gx_hx(fdfy,fdfx,fdfyp,fdfxp,stake); %#ok<ASGLU>

%% Simulation

run_sim_K

%% Compute moments for RBC table

Table_4_create_modeloutput

